<?php
declare(strict_types=1);

// --- robust headers (and no stray output) ---
error_reporting(E_ALL & ~E_NOTICE);
ini_set('display_errors','0');
while (function_exists('ob_get_level') && ob_get_level()) { ob_end_clean(); }
header('Content-Type: application/xml; charset=UTF-8');
header('X-Content-Type-Options: nosniff');

$SITE = 'https://ipcodetv.com';
$ROOT = __DIR__;
$POSTS_DIR = $ROOT . '/Blog/posts';

$urls = [];
$now = new DateTimeImmutable('now', new DateTimeZone('UTC'));
$nowIso = $now->format(DateTimeInterface::ATOM);

$add = function(string $loc, ?string $lastmod, string $changefreq, string $priority, ?string $image = null) use (&$urls) {
  $urls[] = compact('loc','lastmod','changefreq','priority','image');
};

// Home + Blog index
$add($SITE.'/', $nowIso, 'daily', '1.0');
$add($SITE.'/Blog/posts/', $nowIso, 'daily', '0.9');

// Posts (flat HTML files)
if (is_dir($POSTS_DIR)) {
  foreach (glob($POSTS_DIR.'/*.html') as $file) {
    $loc = $SITE . '/Blog/posts/' . basename($file);
    $mtime = (new DateTimeImmutable('@'.filemtime($file)))
              ->setTimezone(new DateTimeZone('UTC'))
              ->format(DateTimeInterface::ATOM);

    // Try to extract an image (og:image first, else first hero <img>)
    $img = null;
    $html = @file_get_contents($file);
    if ($html !== false) {
      if (preg_match('~<meta\s+property=["\']og:image["\']\s+content=["\']([^"\']+)~i', $html, $m)) {
        $img = $m[1];
      } elseif (preg_match('~<img[^>]+src=["\']([^"\']+/Blog/img/img/[^"\']+)["\']~i', $html, $m)) {
        $img = $m[1];
      }
    }

    $add($loc, $mtime, 'weekly', '0.8', $img);
  }
}

// --- OUTPUT XML (no BOM, no spaces before declaration) ---
echo '<?xml version="1.0" encoding="UTF-8"?>', "\n";
?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9"
        xmlns:image="http://www.google.com/schemas/sitemap-image/1.1">
<?php foreach ($urls as $u): ?>
  <url>
    <loc><?= htmlspecialchars($u['loc'], ENT_XML1) ?></loc>
    <?php if (!empty($u['lastmod'])): ?><lastmod><?= htmlspecialchars($u['lastmod'], ENT_XML1) ?></lastmod><?php endif; ?>
    <?php if (!empty($u['changefreq'])): ?><changefreq><?= $u['changefreq'] ?></changefreq><?php endif; ?>
    <?php if (!empty($u['priority'])): ?><priority><?= $u['priority'] ?></priority><?php endif; ?>
    <?php if (!empty($u['image'])): ?>
      <image:image>
        <image:loc><?= htmlspecialchars($u['image'], ENT_XML1) ?></image:loc>
      </image:image>
    <?php endif; ?>
  </url>
<?php endforeach; ?>
</urlset>
