// ipco-chat.js — IPCODETV (FR): chat modern + WhatsApp header logo + gradient + unread badge + sound
(function () {
  const DEF = {
    webhook: {
      url: "https://n8n.srv1165808.hstgr.cloud/webhook/bdc6c878-82a9-453e-9d31-cdd3c92625f1/chat",
      route: "ipcodetv"
    },
    logging: {
      url: "https://ipcodetv.com/chatbot/save_message.php",
      apiKey: "TVP_SECRET_123"
    },
    // Gradient proche du CTA IPCODETV (rose → orange)
    theme:   { from:"#ff4b8b", to:"#ff9a3c" },
    mobile:  { widthPct:0.92, heightPct:0.70, minW:300, maxW:420, minH:380, maxH:640 },
    agent:   {
      name:"Support IPCODETV",
      avatarUrl:"https://tvpluxi.com/SendTest/PhpEmail/chatbot/support/karim.jpg",
      fallbackUrl:"https://ipcodetv.com/chatbot/support/agent-placeholder.jpg"
    },
    replyTiming: { minDelay: 1000, maxDelay: 1800 },     // 1 délai "humain", puis réponse complète
    proactive: {
      enabled:true,
      delayMs:22000,
      minScrollPx:220,
      text:"Besoin d’un coup de main ? Je peux vous guider 🙂",
      onlyOncePerSession:true
    },
    whatsapp:  {
      enabled:true,
      number:"3197010282006", // même numéro que ta config existante
      prefill:"Bonjour ! J’aimerais avoir de l’aide.",
      style:"icon",
      size:36,
      color:"#25D366",
      textColor:"#ffffff",
      label:"WhatsApp"
    }
  };

  // ✅ Numéro WhatsApp par défaut (utilisé pour l’icône dans le header)
  const DEFAULT_WA_NUMBER = "3197010282006";

  // Merge: on accepte soit window.IPCO_ChatConfig soit ton ancien window.TVP2_Config
  const deepMerge = (a,b)=>{const o=JSON.parse(JSON.stringify(a));(function m(x,y){for(const k in y){if(y[k]&&typeof y[k]==="object"&&!Array.isArray(y[k])){x[k]=x[k]||{};m(x[k],y[k]);}else{x[k]=y[k];}}})(o,b||{});return o;};
  const baseCfg =
    (typeof window!=="undefined" && (window.IPCO_ChatConfig || window.TVP2_Config))
      ? (window.IPCO_ChatConfig || window.TVP2_Config)
      : {};
  const CFG = deepMerge(DEF, baseCfg);

  if (document.getElementById("ipco-chat-host")) return;

  // ---------- host + shadow ----------
  const host = document.createElement("div");
  host.id = "ipco-chat-host";
  document.body.appendChild(host);
  const shadow = host.attachShadow({mode:"open"});

  const font = document.createElement("link");
  font.rel = "stylesheet";
  font.href = "https://cdnjs.cloudflare.com/ajax/libs/geist-font/1.0.0/fonts/geist-sans/style.min.css";
  shadow.appendChild(font);

  // ---------- UI ----------
  const HELLO = CFG.proactive?.text || "Bonjour 👋 Comment pouvons-nous vous aider ?";
  const root = document.createElement("div"); root.id = "ipco-chat-root";
  root.innerHTML = `
    <button id="ipco-fab" aria-label="Ouvrir le chat" title="Ouvrir le chat">
      <svg viewBox="0 0 24 24" width="26" height="26" aria-hidden="true" focusable="false">
        <path fill="currentColor" d="M4 4h16a2 2 0 0 1 2 2v10a2 2 0 0 1-2 2H9l-4.5 3.2A1 1 0 0 1 3 20v-2H4a2 2 0 0 1-2-2V6a2 2 0 0 1 2-2Z"/>
      </svg>
      <span id="ipco-badge" class="badge is-hidden">1</span>
    </button>
    <div id="ipco-chat" role="dialog" aria-label="Chat IPCODETV">
      <div class="ipco__shell">
        <div class="ipco__header">
          <div class="ipco__brand">
            <img class="brand-logo" alt="IPCODETV"
                 src="https://ipcodetv.com/css/img/logowebsite.png"
                 referrerpolicy="no-referrer">
            <div class="ttl-wrap">
              <div class="ttl">Support IPCODETV</div>
              <div class="ttl-sub">Activation directe & aide rapide</div>
            </div>
          </div>
          <div class="ipco__actions">
            <a id="ipco-wa-head" class="wa-head" href="#" target="_blank"
               title="Test WhatsApp (envoyer votre appareil)">
              <svg viewBox="0 0 24 24" width="20" height="20" aria-hidden="true" focusable="false">
                <path d="M12.04 2a9.9 9.9 0 0 0-8.47 15.04L2 22l5.08-1.54A9.95 9.95 0 1 0 12.04 2Zm5.82 14.22c-.24.68-1.39 1.29-1.94 1.33-.52.04-1.18.06-1.9-.12-.44-.11-1-.32-1.73-.63-3.05-1.31-5.03-4.36-5.18-4.56-.15-.2-1.24-1.65-1.24-3.16s.78-2.25 1.06-2.56c.28-.31.62-.39.83-.39h.6c.19 0 .45-.07.69.53.24.6.83 2.07.9 2.22.07.15.11.33.02.53-.09.2-.14.33-.28.5-.14.17-.29.38-.42.51-.14.14-.28.3-.12.58.15.28.67 1.1 1.44 1.79 1 0.9 1.85 1.18 2.14 1.32.28.14.45.12.62-.07.17-.19.72-.84.91-1.12.19-.28.38-.23.64-.14.26.09 1.64.77 1.92.91.28.14.46.21.53.33.07.12.07.7-.17 1.38Z"/>
              </svg>
            </a>
            <button class="ipco__close" id="ipco-close" aria-label="Fermer" title="Fermer">&times;</button>
          </div>
        </div>
        <div class="ipco__body">
          <div class="msgs" id="ipco-msgs"></div>
        </div>
        <div class="ipco__footer">
          <input id="ipco-input" type="text" placeholder="Écrivez votre message… (Entrée pour envoyer)"/>
          <button id="ipco-send">Envoyer</button>
        </div>
      </div>
    </div>
  `;
  shadow.appendChild(root);

  // ---------- styles ----------
  const css = document.createElement("style");
  css.textContent = `
    :host{
      --brand-from:${CFG.theme.from};
      --brand-to:${CFG.theme.to};
    }
    :host, #ipco-chat-root{font-family:'Geist Sans',system-ui,-apple-system,Segoe UI,Roboto,Inter,Arial}
    *,*::before,*::after{box-sizing:border-box}

    #ipco-fab{
      position:fixed; right:18px; bottom:18px; z-index:2147483647;
      width:58px; height:58px; border-radius:999px; border:0; cursor:pointer;
      color:#fff; display:grid; place-items:center;
      background:radial-gradient(circle at 10% 0%, var(--brand-from), var(--brand-to));
      box-shadow:0 18px 52px rgba(0,0,0,.65);
    }
    #ipco-fab svg{display:block}
    #ipco-badge{
      position:absolute; top:-4px; right:-4px;
      min-width:20px; height:20px; padding:0 6px;
      display:inline-flex; align-items:center; justify-content:center;
      border-radius:999px; font-size:12px; font-weight:800; line-height:1;
      color:#fff; background:linear-gradient(135deg, var(--brand-from), var(--brand-to));
      box-shadow:0 6px 18px rgba(0,0,0,.45); border:2px solid #050816;
    }
    #ipco-badge.is-hidden{ display:none !important; }

    #ipco-chat{
      position:fixed; right:18px; bottom:18px; z-index:2147483646;
      width:390px; height:600px;
      max-width:calc(100vw - 24px); max-height:calc(100vh - 24px);
      display:none; padding:2px;
      background:radial-gradient(circle at top,#241048 0%,#050816 60%,#050816 100%);
      border-radius:24px;
      box-shadow:0 24px 80px rgba(0,0,0,.85);
      padding-bottom:env(safe-area-inset-bottom);
    }

    .ipco__shell{
      height:100%; width:100%;
      border-radius:22px;
      background:linear-gradient(145deg,#050814,#020617);
      border:1px solid rgba(148,163,184,0.18);
      box-shadow:0 0 0 1px rgba(15,23,42,0.7) inset;
      display:flex; flex-direction:column; overflow:hidden;
      backdrop-filter:blur(18px);
    }

    .ipco__header{
      display:flex; align-items:center; justify-content:space-between; gap:8px;
      padding:12px 14px; color:#fff;
      background:linear-gradient(120deg,rgba(15,23,42,0.9),rgba(15,23,42,0.85));
      border-bottom:1px solid rgba(148,163,184,0.18);
    }
    .ipco__brand{
      display:flex; align-items:center; gap:10px; min-width:0;
    }
    .brand-logo{
      height:30px; width:auto; display:block; border-radius:999px;
      background:#020617;
      box-shadow:0 4px 18px rgba(0,0,0,.75);
      padding:4px;
    }
    .ttl-wrap{min-width:0;}
    .ttl{
      white-space:nowrap; overflow:hidden; text-overflow:ellipsis;
      font-size:14px; font-weight:700;
    }
    .ttl-sub{
      font-size:11px; opacity:.7;
    }

    .ipco__actions{ display:flex; align-items:center; gap:8px; }
    .ipco__close{
      width:34px; height:34px; border-radius:12px; display:grid; place-items:center; flex:0 0 auto;
      border:1px solid rgba(148,163,184,0.35); background:rgba(15,23,42,0.9);
      color:#e5e7eb; cursor:pointer; font-size:18px; line-height:0;
    }

    .wa-head{
      width:34px; height:34px; border-radius:999px;
      display:flex; align-items:center; justify-content:center;
      background:#22c55e;
      color:#fff;
      box-shadow:0 4px 18px rgba(34,197,94,0.55);
      border:1px solid rgba(248,250,252,0.4);
      cursor:pointer;
      flex-shrink:0;
    }
    .wa-head:hover{ transform:translateY(-1px); opacity:.9; }

    .ipco__body{
      flex:1; overflow:auto; padding:14px 12px;
      background:radial-gradient(circle at top,#111827 0%,#020617 55%,#020617 100%);
    }
    .msgs{ display:flex; flex-direction:column; gap:12px; }

    .row{ display:flex; align-items:flex-end; gap:10px; animation:pop .14s ease-out; }
    .row.bot{ flex-direction:row; }
    .row.user{ flex-direction:row-reverse; }

    .avatar{
      width:32px; height:32px; border-radius:999px; flex:0 0 auto; overflow:hidden;
      box-shadow:0 4px 14px rgba(0,0,0,.6); background:#111827;
    }
    .avatar img{ width:100%; height:100%; object-fit:cover; display:block; }

    .bub{
      max-width:82%;
      padding:10px 13px;
      border-radius:18px;
      font-size:14px;
      line-height:1.5;
      word-wrap:break-word; white-space:pre-wrap;
      box-shadow:0 6px 22px rgba(0,0,0,.55);
    }
    .bot .bub{
      color:#f9fafb;
      background:linear-gradient(135deg, var(--brand-from), var(--brand-to));
      border-bottom-left-radius:6px;
      text-shadow:0 1px 0 rgba(0,0,0,.38);
    }
    .user .bub{
      color:#e5e7eb;
      background:rgba(15,23,42,0.98);
      border:1px solid rgba(148,163,184,0.35);
      border-bottom-right-radius:6px;
    }

    @keyframes pop{
      from{transform:translateY(4px) scale(.98);opacity:.0}
      to{transform:translateY(0) scale(1);opacity:1}
    }

    .ipco__footer{
      padding:10px 10px 12px; display:flex; gap:8px; align-items:center;
      background:linear-gradient(180deg,rgba(15,23,42,0.98),rgba(15,23,42,1));
      border-top:1px solid rgba(148,163,184,0.2);
    }
       #ipco-input{
      flex:1; height:42px; border-radius:999px; border:1px solid rgba(55,65,81,0.9); padding:0 13px; outline:none;
      background:rgba(15,23,42,0.95); font-size:16px; -webkit-text-size-adjust:100%;
      color:#e5e7eb;
    }
    #ipco-input::placeholder{ color:#6b7280; }
    #ipco-send{
      height:42px; min-width:96px; border-radius:999px; border:0; cursor:pointer; color:#fff; font-weight:700;
      background:linear-gradient(135deg, var(--brand-from), var(--brand-to)); font-size:16px;
      box-shadow:0 10px 30px rgba(0,0,0,.65);
    }

    #ipco-send:disabled{ opacity:.6; cursor:not-allowed; }

    /* WhatsApp optional floating button (if ever used via CFG.whatsapp) */
    .wa{ text-decoration:none; display:inline-flex; align-items:center; gap:8px; }
    .wa-ico{ display:inline-grid; place-items:center; color:currentColor }
    .wa-txt{ font-weight:800 }
    .wa--icon{
      --wa-size:36px; width:var(--wa-size); height:var(--wa-size); border-radius:50%;
      background:var(--wa-bg,#22c55e); color:var(--wa-ink,#fff);
      border:1px solid #ffffff40; box-shadow:0 6px 16px rgba(0,0,0,.6); justify-content:center;
    }
    .wa--icon .wa-ico{ width:60%; height:60%; } .wa--icon .wa-txt{ display:none }

   @media (max-width: 640px) block in ipco-chat.js with this one:

    /* 📱 Mobile : carte flottante (comme desktop mais plus petite) */
    @media (max-width: 640px){
      #ipco-chat{
        right:10px;
        bottom:10px;
        left:auto;                 /* pas full width */
        width:calc(100vw - 20px);  /* petit margin gauche/droite */
        max-width:420px;           /* limite comme desktop */
        height:75vh;               /* pas toute la hauteur */
        max-height:560px;
        margin:0;
        padding:2px;
        border-radius:18px;
      }

      .ipco__shell{
        border-radius:16px;
        margin:0;
      }

      #ipco-fab{
        right:14px;
        bottom:14px;
        width:54px;
        height:54px;
      }

      .bub{
        font-size:13px;
      }
    }

    .is-hidden{ display:none !important }
  `;
  shadow.appendChild(css);

  // brand vars
  shadow.host.style.setProperty("--brand-from", CFG.theme.from);
  shadow.host.style.setProperty("--brand-to",   CFG.theme.to);

  // ---------- helpers ----------
  const $=(s)=>shadow.querySelector(s);
  const msgs=$("#ipco-msgs"), chat=$("#ipco-chat"), fab=$("#ipco-fab"), closeBtn=$("#ipco-close");
  const input=$("#ipco-input"), sendBtn=$("#ipco-send");
  const waBtn=$("#ipco-wa"), waTxt=waBtn?.querySelector(".wa-txt");
  const badge=$("#ipco-badge");
  const waHead=$("#ipco-wa-head");
  let unreadCount = 0;

  function scrollBottom(){ const body=shadow.querySelector(".ipco__body"); body.scrollTop = body.scrollHeight; }
  function getChatId(){
    try{ let id=localStorage.getItem("ipco_chat_id");
      if(!id){ id="chat_"+Math.random().toString(36).slice(2,11); localStorage.setItem("ipco_chat_id",id); }
      return id;
    }catch(_){ return "chat_"+Math.random().toString(36).slice(2,11); }
  }
  function setBadge(n){
    unreadCount = Math.max(0, n|0);
    if (!badge) return;
    if (unreadCount <= 0){ badge.classList.add("is-hidden"); }
    else { badge.textContent = String(unreadCount); badge.classList.remove("is-hidden"); }
  }

  // ✅ Logo WhatsApp dans le header → ouvre directement WhatsApp
  if (waHead) {
    const raw = (CFG.whatsapp.number && CFG.whatsapp.number.trim())
      || ("+" + DEFAULT_WA_NUMBER);
    const num = raw.replace(/[^\d]/g,"");
    waHead.href = `https://wa.me/${num}?text=${encodeURIComponent(
      "Bonjour ! Message envoyé depuis le live chat, j’ai besoin d’aide"
    )}`;
  }

  // Avatar (photo only)
  function makeAvatar(){
    const wrap=document.createElement("div"); wrap.className="avatar";
    const img=new Image(); img.alt=CFG.agent.name||"Support IPCODETV";
    img.decoding="async"; img.referrerPolicy="no-referrer"; img.loading="eager";
    let usedSrc = CFG.agent.avatarUrl || CFG.agent.fallbackUrl || "";
    if(!usedSrc){ wrap.style.display="none"; return wrap; }
    img.src = usedSrc;
    img.onerror = ()=>{
      if (CFG.agent.fallbackUrl && usedSrc !== CFG.agent.fallbackUrl){
        usedSrc = CFG.agent.fallbackUrl; img.src = CFG.agent.fallbackUrl;
      } else {
        wrap.style.display="none";
      }
    };
    wrap.appendChild(img);
    return wrap;
  }

  // Rows
  function rowUser(text){
    const r=document.createElement("div"); r.className="row user";
    const b=document.createElement("div"); b.className="bub"; b.textContent=String(text);
    r.appendChild(b); msgs.appendChild(r); scrollBottom();
  }
  function rowBot(text){
    const r=document.createElement("div"); r.className="row bot";
    const av=makeAvatar(); const b=document.createElement("div"); b.className="bub"; b.textContent=String(text);
    r.appendChild(av); r.appendChild(b); msgs.appendChild(r); scrollBottom();
    if (chat.style.display !== "flex") setBadge(unreadCount + 1);
  }

  function rowTyping(){
    const r=document.createElement("div"); r.className="row bot";
    const av=makeAvatar(); const b=document.createElement("div"); b.className="bub";
    b.textContent = "En train d'écrire…";
    r.appendChild(av); r.appendChild(b); msgs.appendChild(r); scrollBottom(); return r;
  }

  // ---- Sound (first hello only) with queued autoplay fallback ----
  let audioEl=null, helloPlayed=false, helloQueued=false;
  function initAudio(){
    if(audioEl) return;
    audioEl=document.createElement("audio");
    audioEl.preload="auto";
    audioEl.src="data:audio/wav;base64,UklGRjQAAABXQVZFZm10IBAAAAABAAEAESsAACJWAAACABYAAAChAAAAAAAAgACAgICAgP8AAP//AACAgICAf4CAgICA";
    const unlock = ()=>{ audioEl.play().then(()=>{ audioEl.pause(); audioEl.currentTime=0; }).catch(()=>{}); removeUnlockers(); };
    function addUnlockers(){ ["pointerdown","keydown","scroll","touchstart"].forEach(ev=>document.addEventListener(ev, unlock, {once:true, passive:true, capture:true})); }
    function removeUnlockers(){ ["pointerdown","keydown","scroll","touchstart"].forEach(ev=>document.removeEventListener(ev, unlock, {capture:true})); }
    addUnlockers();
  }
  function tryPlayHelloNow(){
    if(!audioEl || helloPlayed) return Promise.resolve();
    audioEl.currentTime = 0;
    return audioEl.play()
      .then(()=>{ helloPlayed=true; })
      .catch(()=>{ helloQueued=true; });
  }
  function playQueuedOnGesture(){
    if(!helloQueued || !audioEl || helloPlayed) return;
    const fire = ()=>{ audioEl.currentTime=0; audioEl.play().then(()=>{ helloPlayed=true; }).catch(()=>{}); cleanup(); };
    const cleanup = ()=>["pointerdown","keydown","scroll","touchstart"].forEach(ev=>document.removeEventListener(ev, fire, {capture:true}));
    ["pointerdown","keydown","scroll","touchstart"].forEach(ev=>document.addEventListener(ev, fire, {once:true, passive:true, capture:true}));
  }

  // Logging
  async function ipcoLog(role,text){
    if(!CFG.logging||!CFG.logging.url||!CFG.logging.apiKey) return;
    const body = {
      apiKey: CFG.logging.apiKey,
      chatId: getChatId(),
      route:  CFG.webhook.route || "ipcodetv",
      role,
      message: String(text||""),
      site: location.hostname || ""
    };
    try{
      await fetch(CFG.logging.url,{method:"POST",headers:{"Content-Type":"application/json"}, body:JSON.stringify(body)});
    }catch(e){ console.warn("ipcoLog failed",e); }
  }

  // Optional extra WhatsApp button if ever used in HTML
  function setupWhatsApp(){
    if(!waBtn) return;
    const W=CFG.whatsapp||{}; const number=(W.number||"").replace(/[^\d]/g,"");
    if(!W.enabled||!number){ waBtn.classList.add("is-hidden"); return; }
    waBtn.classList.remove("is-hidden"); waBtn.classList.add("wa--icon");
    waBtn.style.setProperty("--wa-bg", W.color||"#22c55e");
    waBtn.style.setProperty("--wa-ink", W.textColor||"#ffffff");
    waBtn.style.setProperty("--wa-size", (W.size||36)+"px");
    if(waTxt){ waTxt.textContent = ""; }
    const buildHref=()=>`https://wa.me/${number}?text=${encodeURIComponent((W.prefill||"Bonjour !")+" (chat "+getChatId()+")")}`;
    waBtn.href=buildHref(); waBtn.addEventListener("click", ()=>{waBtn.href=buildHref();}, {capture:true});
  }

  // Open/close UI
  const openChat = ()=>{
    chat.style.display="flex"; fab.style.display="none"; input.focus();
    setBadge(0);
    setupWhatsApp();
  };

  fab.addEventListener("click", openChat);
  closeBtn.addEventListener("click", ()=>{ chat.style.display="none"; fab.style.display="grid"; });

  // Send flow
  sendBtn.addEventListener("click", async ()=>{
    const message=(input.value||"").trim(); if(!message||sendBtn.disabled) return;
    rowUser(message); input.value=""; input.focus(); sendBtn.disabled=true;
    ipcoLog("user",message);

    const typingRow = rowTyping();
    const minD = Number(CFG.replyTiming.minDelay)||900;
    const maxD = Number(CFG.replyTiming.maxDelay)||1700;
    const delay = minD + Math.random()*(Math.max(minD,maxD)-minD);

    try{
      const target=CFG.webhook&&CFG.webhook.url?CFG.webhook.url:"";
      if(!target) throw new Error("Missing webhook URL");

      // 🔁 Payload aligné avec ton nœud "When chat message received" (sessionId, action, chatInput)
      const payload = {
        sessionId: getChatId(),
        action: "sendMessage",
        chatInput: message,
        route: CFG.webhook.route || "ipcodetv"
      };

      const res = await fetch(target,{
        method:"POST",
        headers:{"Content-Type":"application/json"},
        body:JSON.stringify(payload)
      });

      // On accepte JSON ou texte simple
      let raw = "";
      let data = {};
      try {
        raw = await res.text();
        try {
          data = JSON.parse(raw || "{}");
        } catch (_){
          // si ce n’est pas du JSON, on prend la réponse brute comme output
          data = { output: raw };
        }
      } catch (_){
        data = {};
      }

      const reply =
        data?.output ??
        data?.text ??
        data?.data ??
        "Désolé, je n'ai pas bien compris.";

      await new Promise(r=>setTimeout(r, delay));
      typingRow.remove();
      rowBot(reply);
      ipcoLog("bot",reply);
    }catch(err){
      await new Promise(r=>setTimeout(r, delay));
      typingRow.remove();
      const fail="Erreur réseau. Merci de réessayer dans un instant.";
      rowBot(fail);
      ipcoLog("bot",fail);
      console.error(err);
    }finally{
      sendBtn.disabled=false; scrollBottom();
    }
  });

  input.addEventListener("keydown",(e)=>{ if(e.key==="Enter"&&!e.shiftKey){ e.preventDefault(); sendBtn.click(); } });

  // First visit hello
  initAudio();
  (function firstHello(){
    if(!CFG.proactive || CFG.proactive.enabled === false) return;
    const KEY="ipco_greeted_once";
    if (CFG.proactive.onlyOncePerSession && sessionStorage.getItem(KEY)) return;
    setTimeout(async ()=>{
      const hasUserMsg=!!shadow.querySelector(".row.user");
      if(!hasUserMsg){
        rowBot(HELLO);
        ipcoLog("bot",HELLO);
        if (chat.style.display !== "flex") setBadge(unreadCount + 1);
        await tryPlayHelloNow();
        playQueuedOnGesture();
      }
      sessionStorage.setItem(KEY,"1");
    }, Math.max(0, CFG.proactive.delayMs || 3000));
  })();

  shadow.host.style.setProperty("--brand-from", CFG.theme.from);
  shadow.host.style.setProperty("--brand-to",   CFG.theme.to);
})();
