<?php
/* =========================================================
 * TVPLUXI — Chats Admin (single-file dashboard)
 * Fixes:
 * - Conversation list now uses the most recent user IP (no “today” limit)
 * - Per-message country/flag still shown in thread
 * - Safer flag output fallback if mbstring is missing
 * - Keeps site domain everywhere
 * ========================================================= */

/* ===================== CONFIG ===================== */
$DB_HOST = 'localhost';
$DB_NAME = 'tvnuzqfp_LoginPluxi';
$DB_USER = 'tvnuzqfp_YoussefDataLogin';
$DB_PASS = 'N67M5aLYQHM}';

$WEBHOOK_URL    = 'https://aidihamid461.app.n8n.cloud/webhook/acfe8a61-bdb2-401e-b383-117b20fc8c68/chat'; // (not used for admin-send)
$DEFAULT_ROUTE  = 'general';
$ADMIN_PASSWORD = ''; // e.g. 'ChangeMe!123' or '' to disable login

/* ===================== DB ===================== */
function pdo() {
  static $pdo = null;
  if ($pdo) return $pdo;
  global $DB_HOST,$DB_NAME,$DB_USER,$DB_PASS;
  $pdo = new PDO(
    "mysql:host=$DB_HOST;dbname=$DB_NAME;charset=utf8mb4",
    $DB_USER,$DB_PASS,
    [
      PDO::ATTR_ERRMODE=>PDO::ERRMODE_EXCEPTION,
      PDO::ATTR_DEFAULT_FETCH_MODE=>PDO::FETCH_ASSOC
    ]
  );

  // helper tables
  $pdo->exec("CREATE TABLE IF NOT EXISTS chat_settings(
    chat_id VARCHAR(64) PRIMARY KEY,
    bot_muted TINYINT(1) NOT NULL DEFAULT 0,
    updated_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

  $pdo->exec("CREATE TABLE IF NOT EXISTS ip_geo_cache(
    ip VARCHAR(45) PRIMARY KEY,
    cc CHAR(2),
    country VARCHAR(80),
    updated_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

  // ensure chat_messages.site exists
  try {
    $has = $pdo->query("SHOW COLUMNS FROM chat_messages LIKE 'site'")->fetch();
    if (!$has) $pdo->exec("ALTER TABLE chat_messages ADD COLUMN site VARCHAR(120) NULL AFTER route");
  } catch (Throwable $e) { /* ignore perms on shared hosting */ }

  return $pdo;
}

/* ===================== AUTH (very simple) ===================== */
session_start();
if ($ADMIN_PASSWORD !== '') {
  if (isset($_GET['logout'])) { session_destroy(); header('Location: '.$_SERVER['PHP_SELF']); exit; }
  if (!isset($_SESSION['ok'])) {
    if (isset($_GET['login']) && $_SERVER['REQUEST_METHOD']==='POST') {
      if (hash_equals($ADMIN_PASSWORD, $_POST['pass'] ?? '')) { $_SESSION['ok']=1; header('Location: '.$_SERVER['PHP_SELF']); exit; }
      $err="Wrong password";
    }
    if (!isset($_SESSION['ok'])) {
      ?>
      <!doctype html><html><head><meta charset="utf-8"><meta name=viewport content="width=device-width,initial-scale=1">
      <title>Chat Admin Login</title>
      <style>
        :root { --bg:#f6f7fb; --brand1:#3B82F6; --brand2:#7C3AED; }
        body{margin:0;background:var(--bg);font:16px/1.4 system-ui,-apple-system,Segoe UI,Roboto,Inter,Arial;display:grid;min-height:100vh;place-items:center}
        .panel{background:#fff;border:1px solid #e7e9f2;border-radius:18px;box-shadow:0 12px 36px rgba(24,32,79,.06);padding:24px;width:min(440px,92vw)}
        .title{font-weight:800;font-size:20px;margin:0 0 14px}
        .inp{width:100%;padding:10px 12px;border:1px solid #e5e7eb;border-radius:12px;margin:0 0 12px;font-size:16px}
        .btn{width:100%;border:0;border-radius:12px;padding:12px 14px;color:#fff;font-weight:700;background:linear-gradient(135deg,var(--brand1),var(--brand2));cursor:pointer}
        .err{color:#dc2626;font-size:14px;margin:0 0 10px}
      </style></head><body>
      <form method="post" action="?login=1" class="panel">
        <h1 class="title">Chat Admin</h1>
        <?php if(!empty($err)):?><div class="err"><?=htmlspecialchars($err)?></div><?php endif;?>
        <input class="inp" type="password" name="pass" placeholder="Password" required>
        <button class="btn">Enter</button>
      </form></body></html><?php
      exit;
    }
  }
}

/* ===================== HELPERS ===================== */
function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES,'UTF-8'); }
function ts($s){ return date('Y-m-d H:i', strtotime($s)); }

function flag_emoji($cc){
  $cc = strtoupper((string)$cc);
  if (!preg_match('/^[A-Z]{2}$/',$cc)) return '';
  // Try to build the regional indicator flag. If mbstring not available, fall back to code.
  $cp1 = ord($cc[0])-65+0x1F1E6; $cp2 = ord($cc[1])-65+0x1F1E6;
  $flag = @mb_convert_encoding('&#'.$cp1.';','UTF-8','HTML-ENTITIES')
        . @mb_convert_encoding('&#'.$cp2.';','UTF-8','HTML-ENTITIES');
  if (!$flag || strpos($flag,'&#')!==false) return $cc; // fallback text
  return $flag;
}

function geo_from_ip($ip){
  if (!$ip) return [null,null];
  $pdo = pdo();
  $row = $pdo->prepare("SELECT cc,country,updated_at FROM ip_geo_cache WHERE ip=?");
  $row->execute([$ip]);
  $r = $row->fetch();
  if ($r && strtotime($r['updated_at']) > time()-7*24*3600) return [$r['cc'],$r['country']];

  try{
    $ch = curl_init("https://ipapi.co/".rawurlencode($ip)."/json/");
    curl_setopt_array($ch,[CURLOPT_RETURNTRANSFER=>true, CURLOPT_TIMEOUT=>5]);
    $res = curl_exec($ch);
    curl_close($ch);
    $data = @json_decode($res,true);
    $cc = strtoupper($data['country_code'] ?? '');
    $country = $data['country_name'] ?? '';
    if ($cc==='') { $cc = null; $country = null; }
  }catch(Throwable $e){ $cc=null; $country=null; }
  $pdo->prepare("REPLACE INTO ip_geo_cache(ip,cc,country) VALUES(?,?,?)")->execute([$ip,$cc,$country]);
  return [$cc,$country];
}

function detect_phone(?string $s): ?string {
  if (!$s) return null;
  if (preg_match('/(\+?\d[\d\s\-]{7,}\d)/', $s, $m)) {
    $raw = $m[1];
    $clean = preg_replace('/[^\d\+]/','',$raw);
    $prefix = (strpos($raw,'+')===0) ? '+' : '';
    $digits = ltrim($clean, '+');
    $digits = preg_replace('/(?<=\d)(?=(\d{2})+(?!\d))/', ' ', $digits);
    return $prefix.$digits;
  }
  return null;
}
function favicon($domain){
  if(!$domain) return 'data:image/svg+xml;utf8,<svg xmlns=%22http://www.w3.org/2000/svg%22 viewBox=%220 0 24 24%22><circle cx=%2212%22 cy=%2212%22 r=%229%22 fill=%22%23d1d5db%22/></svg>';
  return 'https://www.google.com/s2/favicons?domain='.urlencode($domain).'&sz=64';
}

/* ===================== AJAX ===================== */
// Thread loader — today
if (isset($_GET['ajax']) && $_GET['ajax']==='thread') {
  $chatId = $_GET['chat_id'] ?? '';
  if ($chatId===''){ http_response_code(400); echo json_encode(['ok'=>false,'error'=>'missing_chat_id']); exit; }
  header('Content-Type: application/json; charset=utf-8');
  $stmt = pdo()->prepare("
    SELECT id, role, message, route, site, ip, user_agent, created_at
    FROM chat_messages
    WHERE chat_id = ?
      AND created_at >= CURDATE()
      AND created_at <  CURDATE() + INTERVAL 1 DAY
    ORDER BY id ASC
  ");
  $stmt->execute([$chatId]);
  $items = $stmt->fetchAll();

  foreach ($items as &$it) {
    if ($it['role'] === 'user') { [$cc,$country] = geo_from_ip($it['ip'] ?? null); $it['cc']=$cc; $it['country']=$country; }
    else { $it['cc']=null; $it['country']=null; }
  } unset($it);
  echo json_encode(['ok'=>true,'items'=>$items]); exit;
}

// Admin sends as BOT
if (isset($_POST['ajax']) && $_POST['ajax']==='send') {
  header('Content-Type: application/json; charset=utf-8');
  $chatId = trim($_POST['chat_id'] ?? '');
  $text   = trim($_POST['message'] ?? '');
  $route  = trim($_POST['route'] ?? $DEFAULT_ROUTE);
  if ($chatId==='' || $text===''){ echo json_encode(['ok'=>false,'error'=>'missing_fields']); exit; }
  $ins = pdo()->prepare("INSERT INTO chat_messages (chat_id, role, message, route, site, ip, user_agent) VALUES (?,?,?,?,?,?,?)");
  $ins->execute([$chatId,'bot',$text,$route,null,$_SERVER['REMOTE_ADDR']??null,'admin-ui']);
  echo json_encode(['ok'=>true,'reply'=>$text]); exit;
}

// Bot state get/set
if (isset($_GET['ajax']) && $_GET['ajax']==='bot_state') {
  header('Content-Type: application/json; charset=utf-8');
  $chatId = $_GET['chat_id'] ?? '';
  if ($chatId===''){ echo json_encode(['ok'=>false,'error'=>'missing_chat_id']); exit; }
  $row = pdo()->prepare("SELECT bot_muted FROM chat_settings WHERE chat_id=?");
  $row->execute([$chatId]); $muted = (int)($row->fetch()['bot_muted'] ?? 0);
  echo json_encode(['ok'=>true,'muted'=>$muted?true:false]); exit;
}
if (isset($_POST['ajax']) && $_POST['ajax']==='set_bot') {
  header('Content-Type: application/json; charset=utf-8');
  $chatId = $_POST['chat_id'] ?? ''; $muted  = (int)($_POST['muted'] ?? 0);
  if ($chatId===''){ echo json_encode(['ok'=>false,'error'=>'missing_chat_id']); exit; }
  pdo()->prepare("REPLACE INTO chat_settings(chat_id, bot_muted) VALUES(?,?)")->execute([$chatId,$muted?1:0]);
  echo json_encode(['ok'=>true]); exit;
}

/* ===================== DASHBOARD DATA ===================== */
$pdo = pdo();

// totals
$today = date('Y-m-d');
$totals = $pdo->query("SELECT SUM(created_at >= '$today 00:00:00') AS msgs_today, COUNT(*) AS msgs_total FROM chat_messages")->fetch();

// last 7 days series
$series = [];
for($i=6;$i>=0;$i--){ $series[date('Y-m-d', strtotime("-$i day"))]=0; }
$rows = $pdo->query("
  SELECT DATE(created_at) d, COUNT(*) c
  FROM chat_messages
  WHERE created_at >= DATE_SUB(CURDATE(), INTERVAL 7 DAY)
  GROUP BY d
")->fetchAll();
foreach($rows as $r){ $series[$r['d']] = (int)$r['c']; }

/* Conversations list (TODAY for the list),
 * BUT: last_user_ip / last_user_msg now fetched **without** a day limit
 * so we always have a country + label if the chat ever had a user message. */
$list = $pdo->query("
  SELECT
    t.chat_id,
    t.route,
    t.cnt,
    m.message AS last_msg,
    m.created_at AS last_at,
    (
      SELECT ip FROM chat_messages
      WHERE chat_id = t.chat_id AND role='user' AND ip IS NOT NULL
      ORDER BY id DESC LIMIT 1
    ) AS last_user_ip,
    (
      SELECT message FROM chat_messages
      WHERE chat_id = t.chat_id AND role='user'
      ORDER BY id DESC LIMIT 1
    ) AS last_user_msg,
    (
      SELECT site FROM chat_messages
      WHERE chat_id = t.chat_id AND site IS NOT NULL AND site <> ''
        AND created_at >= CURDATE() AND created_at <  CURDATE() + INTERVAL 1 DAY
      ORDER BY id DESC LIMIT 1
    ) AS site_domain
  FROM (
    SELECT chat_id, MAX(id) max_id, COUNT(*) cnt, MIN(route) route
    FROM chat_messages
    WHERE created_at >= CURDATE()
      AND created_at <  CURDATE() + INTERVAL 1 DAY
    GROUP BY chat_id
  ) t
  JOIN chat_messages m ON m.id = t.max_id
  ORDER BY m.id DESC
  LIMIT 200
")->fetchAll();

// enrich conversation rows
foreach ($list as &$r) {
  [$cc,$country] = geo_from_ip($r['last_user_ip'] ?? null);
  $r['_cc']      = $cc;
  $r['_country'] = $country;
  $r['_phone']   = detect_phone($r['last_user_msg'] ?? '');
  $r['_site']    = $r['site_domain'] ?: 'unknown';
}
unset($r);

$convCount = count($list);
?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>Chats Admin — TVPLUXI</title>
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://cdnjs.cloudflare.com/ajax/libs/geist-font/1.0.0/fonts/geist-sans/style.min.css" rel="stylesheet">
<style>
:root{
  --bg:#f5f7fb; --card:#fff; --ink:#0f172a; --muted:#6b7280; --line:#e7e9f2;
  --brand1:#6366F1; --brand2:#A855F7; --pill-bg:#eef2ff; --pill-ink:#3949ab;
  --grad: linear-gradient(135deg,var(--brand1),var(--brand2));
}
*{box-sizing:border-box}
body{margin:0;background:var(--bg);color:var(--ink);font:15.5px/1.5 'Geist Sans',system-ui,-apple-system,Segoe UI,Roboto,Inter,Arial}
.container{max-width:1240px;margin:0 auto;padding:18px}
.header{display:flex;align-items:center;justify-content:space-between;margin-bottom:12px}
.leftHead{display:flex;align-items:center;gap:12px}
.badge{background:linear-gradient(135deg,#ff7eb3,#ff758c);color:#fff;border-radius:999px;padding:6px 12px;font-size:12px;font-weight:800;box-shadow:0 10px 24px rgba(24,32,79,.08)}
h1{margin:0;font-size:26px;font-weight:900}
.pill{background:var(--pill-bg);color:var(--pill-ink);font-weight:800;border-radius:999px;padding:6px 10px;font-size:12px;border:1px solid #dfe3ff}
.row{display:grid;grid-template-columns:repeat(3,1fr);gap:12px;margin-bottom:12px}
.card{background:var(--card);border:1px solid var(--line);border-radius:18px;box-shadow:0 12px 36px rgba(24,32,79,.06);overflow:hidden}
.body{padding:16px}
.stat .title{color:var(--muted);font-weight:700;font-size:14px}
.stat .value{font-size:34px;font-weight:900}
.barbox{display:flex;align-items:flex-end;gap:10px;height:96px}
.bar{width:12%;background:#c7d2fe;border-radius:6px}
.grid2{display:grid;grid-template-columns:360px 1fr;gap:12px}
@media (max-width:980px){ .row{grid-template-columns:1fr} .grid2{grid-template-columns:1fr} }
.list{height:70vh;overflow:auto;padding:10px}
.item{width:100%;text-align:left;background:transparent;border:1px solid transparent;padding:12px;border-radius:14px;display:block;cursor:pointer;transition:.15s}
.item:hover{background:#f8fafc;border-color:#e5e7eb;transform:translateY(-1px)}
.item-top{display:flex;align-items:center;justify-content:space-between;margin-bottom:6px}
.muted{color:var(--muted);font-size:12.5px}
.muted-xs{color:#9aa3af;font-size:11px}
.country{display:inline-flex;align-items:center;gap:6px}
.thread{display:flex;flex-direction:column;height:70vh}
.thread-head{position:sticky;top:0;backdrop-filter:saturate(160%) blur(6px);background:#ffffffd9;border-bottom:1px solid var(--line);display:flex;align-items:center;justify-content:space-between;padding:12px 16px;z-index:5}
.thread-body{flex:1;padding:18px;background:linear-gradient(180deg,#fff 0%,#f6f8ff 100%);overflow:auto}
.thread-foot{display:flex;gap:8px;padding:12px;border-top:1px solid var(--line);background:#fff}
.inp{flex:1;padding:12px 14px;border:1px solid #e5e7eb;border-radius:14px;font-size:16px;outline:none;background:#fbfcff}
.btn{border:0;border-radius:12px;padding:12px 16px;color:#fff;font-weight:800;background:var(--grad);cursor:pointer}
.btn:disabled{opacity:.6;cursor:not-allowed}
.msg{max-width:78%;padding:12px 14px;border-radius:16px;box-shadow:0 6px 16px rgba(24,32,79,.06);font-size:14.5px}
.msg-bot{background:var(--grad);color:#fff;border-bottom-left-radius:8px}
.msg-user{background:#ffffff;color:#111827;border:1px solid #e5e7eb;border-bottom-right-radius:8px}
.rowline{display:flex;margin-bottom:6px}
.rowline.justify-end{justify-content:end}
.meta{font-size:11px;color:#9aa3af;margin:6px 6px 12px;display:flex;align-items:center;gap:8px;flex-wrap:wrap}
.title-sm{font-size:13px;color:var(--muted);font-weight:700}
.title-lg{font-size:18px;font-weight:900}
.search{padding:10px 12px;border:1px solid #e5e7eb;border-radius:12px;font-size:14px;width:52%}
.toggle{display:inline-flex;align-items:center;gap:8px}
.switch{appearance:none;width:44px;height:24px;border-radius:999px;background:#e5e7eb;position:relative;outline:none;cursor:pointer;transition:.2s}
.switch:checked{background:var(--grad)}
.switch:before{content:'';position:absolute;top:3px;left:3px;width:18px;height:18px;border-radius:50%;background:#fff;transition:.2s;box-shadow:0 1px 3px rgba(0,0,0,.24)}
.switch:checked:before{left:23px}
.logo{height:32px;width:auto;display:block}
.userTag{display:inline-flex;align-items:center;gap:8px;font-weight:800}
.avatarDot{width:8px;height:8px;border-radius:999px;background:#10B981;box-shadow:0 0 0 2px #fff}
.sitechip{display:inline-flex;align-items:center;gap:6px;background:#fff;border:1px solid #e5e7eb;padding:4px 8px;border-radius:999px;font-size:12px}
.sitechip img{width:14px;height:14px;border-radius:3px}
.sitefilter{display:flex;gap:8px;align-items:center}
</style>
</head>
<body>
<div class="container">

  <!-- Header -->
  <div class="header">
    <div class="leftHead">
      <img src="/assets/tvpluxi-logo.svg" alt="TVPLUXI" class="logo">
      <span class="badge">PLUXI—Dashboard</span>
      <h1>Chats Admin</h1>
    </div>
    <div style="display:flex;align-items:center;gap:8px">
      <a class="pill" href="../dashbo2.php" title="Go to Sales Dashboard">Dashboard</a>
      <?php if($ADMIN_PASSWORD!==''): ?><a class="pill" href="?logout=1">Logout</a><?php endif; ?>
      <span class="pill">Conversations: <?= (int)$convCount ?></span>
    </div>
  </div>

  <!-- Top stats -->
  <div class="row">
    <div class="card stat"><div class="body">
      <div class="title">Messages Today</div>
      <div style="display:flex;align-items:flex-end;gap:10px;margin-top:8px">
        <div class="stat value"><?= (int)$totals['msgs_today'] ?></div>
        <span class="badge">Today</span>
      </div>
    </div></div>

    <div class="card stat"><div class="body">
      <div class="title">Total Messages</div>
      <div class="stat value" style="margin-top:8px"><?= (int)$totals['msgs_total'] ?></div>
    </div></div>

    <div class="card"><div class="body">
      <div class="title" style="margin-bottom:8px">Last 7 Days</div>
      <div class="barbox">
        <?php foreach($series as $d=>$v): $h = max(6, min(100, $v*8)); ?>
          <div style="display:flex;flex-direction:column;align-items:center;justify-content:flex-end;width:12%;">
            <div class="bar" style="height:<?= $h ?>%"></div>
            <div class="muted-xs" style="margin-top:6px"><?= date('d M', strtotime($d)) ?></div>
          </div>
        <?php endforeach; ?>
      </div>
    </div></div>
  </div>

  <!-- Conversations + Thread -->
  <div class="grid2">

    <!-- Left: conversations (TODAY only) -->
    <div class="card">
      <div class="body" style="padding-bottom:6px;display:flex;align-items:center;justify-content:space-between;gap:10px">
        <div class="title-sm">Conversations</div>
        <div class="sitefilter">
          <input id="search" class="search" placeholder="Search chat_id or site…">
        </div>
      </div>
      <div id="conv-list" class="list">
        <?php $i=0; foreach($list as $r): $i++; ?>
          <?php
            $label = $r['_phone'] ? $r['_phone'] : ('User #'.$i);
            $countryBadge = '';
            if ($r['_cc']) {
              $countryBadge = '<span class="country"><span>'.flag_emoji($r['_cc']).'</span><span class="muted-xs">'.h($r['_country'] ?: $r['_cc']).'</span></span>';
            }
            $domain = h($r['_site']);
            $favicon = favicon($r['_site']!=='unknown' ? $r['_site'] : null);
          ?>
          <button
            class="item"
            data-chat="<?= h($r['chat_id']) ?>"
            data-route="<?= h($r['route']) ?>"
            data-phone="<?= h($r['_phone'] ?? '') ?>"
            data-cc="<?= h($r['_cc'] ?? '') ?>"
            data-country="<?= h($r['_country'] ?? '') ?>"
            data-site="<?= $domain ?>"
          >
            <div class="item-top">
              <div class="userTag">
                <span class="avatarDot"></span>
                <span><?= $label ?></span>
                <?= $countryBadge ?>
              </div>
              <span class="pill"><?= (int)$r['cnt'] ?> msgs</span>
            </div>
            <div style="display:flex;align-items:center;gap:8px;flex-wrap:wrap">
              <span class="sitechip" title="Website"><img src="<?= $favicon ?>" alt=""> <?= $domain ?></span>
              <span class="muted">• <?= h(mb_strimwidth($r['last_msg'],0,70,'…','UTF-8')) ?></span>
            </div>
            <div class="muted-xs" style="margin-top:6px"><?= h(ts($r['last_at'])) ?> • route: <?= h($r['route']) ?></div>
          </button>
        <?php endforeach; ?>
      </div>
    </div>

    <!-- Right: thread (TODAY only) -->
    <div class="card thread">
      <div class="thread-head">
        <div>
          <div class="title-sm">Chat</div>
          <div id="thread-title" class="title-lg">Select a conversation</div>
          <div id="thread-sub" class="muted" style="margin-top:2px"></div>
        </div>
        <div style="display:flex;align-items:center;gap:10px;flex-wrap:wrap">
          <div class="toggle">
            <label class="muted" for="mute">Bot auto-reply</label>
            <input id="mute" class="switch" type="checkbox" checked>
          </div>
          <div id="thread-site" class="sitechip" title="Website" style="display:none">
            <img id="thread-favicon" src="" alt="">
            <span id="thread-domain"></span>
          </div>
          <div id="thread-route" class="pill"><?= h($DEFAULT_ROUTE) ?></div>
        </div>
      </div>
      <div id="thread-body" class="thread-body"></div>
      <form id="reply-form" class="thread-foot">
        <input type="hidden" id="chatId">
        <input type="hidden" id="route" value="<?= h($DEFAULT_ROUTE) ?>">
        <input id="reply" class="inp" placeholder="Écrivez votre message… (Entrée pour envoyer)">
        <button class="btn" id="sendBtn" type="submit">Envoyer</button>
      </form>
    </div>

  </div>
</div>

<script>
const listEl = document.getElementById('conv-list');
const searchEl = document.getElementById('search');
const tTitle = document.getElementById('thread-title');
const tSub   = document.getElementById('thread-sub');
const tRoute = document.getElementById('thread-route');
const tBody  = document.getElementById('thread-body');
const form   = document.getElementById('reply-form');
const chatIdEl = document.getElementById('chatId');
const routeEl  = document.getElementById('route');
const replyEl  = document.getElementById('reply');
const sendBtn  = document.getElementById('sendBtn');
const muteEl   = document.getElementById('mute');
const tSite    = document.getElementById('thread-site');
const tFav     = document.getElementById('thread-favicon');
const tDomain  = document.getElementById('thread-domain');

function faviconURL(domain){
  if(!domain || domain==='unknown') return 'data:image/svg+xml;utf8,<svg xmlns=%22http://www.w3.org/2000/svg%22 viewBox=%220 0 24 24%22><circle cx=%2212%22 cy=%2212%22 r=%229%22 fill=%22%23d1d5db%22/></svg>';
  return 'https://www.google.com/s2/favicons?domain='+encodeURIComponent(domain)+'&sz=64';
}

function bubble(role, text, ts, cc, country, site){
  const row = document.createElement('div');
  row.className = 'rowline ' + (role==='user' ? 'justify-end' : '');
  const col = document.createElement('div');
  const b = document.createElement('div');
  b.className = 'msg ' + (role==='user' ? 'msg-user' : 'msg-bot');
  b.textContent = text;

  const meta = document.createElement('div');
  meta.className = 'meta';

  if (role==='user' && cc && cc.length===2){
    const base = 0x1F1E6, A='A'.charCodeAt(0);
    const cp1 = base + (cc[0].toUpperCase().charCodeAt(0)-A);
    const cp2 = base + (cc[1].toUpperCase().charCodeAt(0)-A);
    const flag = String.fromCodePoint(cp1,cp2);
    const span = document.createElement('span');
    span.textContent = `${flag} ${country || cc}`;
    meta.appendChild(span);
  }

  if (site && site !== 'unknown'){
    const chip = document.createElement('span');
    chip.className = 'sitechip';
    const img = document.createElement('img');
    img.src = faviconURL(site); img.alt = '';
    chip.appendChild(img);
    chip.appendChild(document.createTextNode(' '+site));
    meta.appendChild(chip);
  }

  const tspan = document.createElement('span'); tspan.textContent = ts || '';
  meta.appendChild(tspan);

  col.appendChild(b); col.appendChild(meta); row.appendChild(col);
  return row;
}

function scrollBottom(){ tBody.scrollTop = tBody.scrollHeight; }
async function getJSON(url){ const r = await fetch(url); return await r.json(); }

function humanTitleFromBtn(btn){
  const phone = (btn.dataset.phone||'').trim();
  const cc = (btn.dataset.cc||'').trim();
  const country = (btn.dataset.country||'').trim();
  let title = phone && phone.length ? phone : 'User';
  if (cc && cc.length===2) {
    const base = 0x1F1E6, A = 'A'.charCodeAt(0);
    const cp1 = base + (cc[0].toUpperCase().charCodeAt(0)-A);
    const cp2 = base + (cc[1].toUpperCase().charCodeAt(0)-A);
    const flag = String.fromCodePoint(cp1, cp2);
    title = `${title} · ${flag}`;
    tSub.textContent = country || cc;
  } else {
    tSub.textContent = '';
  }
  return title;
}

function setThreadSite(domain){
  if(domain && domain!=='unknown'){
    tFav.src = faviconURL(domain);
    tDomain.textContent = domain;
    tSite.style.display = 'inline-flex';
  } else {
    tSite.style.display = 'none';
  }
}

async function loadThread(chatId, route, domainFromRow){
  tTitle.textContent = '#'+chatId;
  tRoute.textContent = route || 'general';
  setThreadSite(domainFromRow || '');
  tBody.innerHTML = '<div class="muted">Loading…</div>';
  const data = await getJSON('?ajax=thread&chat_id='+encodeURIComponent(chatId));
  tBody.innerHTML = '';
  (data.items || []).forEach(it=>{
    const when = new Date(it.created_at.replace(' ','T')+'Z');
    const site = (it.site && it.site.length) ? it.site : (domainFromRow || '');
    tBody.appendChild(bubble(it.role, it.message, when.toLocaleString(), it.cc, it.country, site));
  });
  chatIdEl.value = chatId;
  routeEl.value = route || 'general';
  scrollBottom();
  const st = await getJSON('?ajax=bot_state&chat_id='+encodeURIComponent(chatId));
  muteEl.checked = !(st.muted === true);
}

listEl.addEventListener('click', e=>{
  const btn = e.target.closest('button[data-chat]');
  if(!btn) return;
  [...listEl.querySelectorAll('button[data-chat]')].forEach(b=>b.style.background='transparent');
  btn.style.background = '#f3f4f6';
  tTitle.textContent = humanTitleFromBtn(btn);
  setThreadSite(btn.dataset.site || '');
  loadThread(btn.dataset.chat, btn.dataset.route, btn.dataset.site || '');
});

searchEl.addEventListener('input', ()=>{
  const q = searchEl.value.toLowerCase();
  listEl.querySelectorAll('button[data-chat]').forEach(btn=>{
    const id   = (btn.dataset.chat||'').toLowerCase();
    const site = (btn.dataset.site||'').toLowerCase();
    btn.style.display = (id.includes(q) || site.includes(q)) ? '' : 'none';
  });
});

muteEl.addEventListener('change', async ()=>{
  const chatId = chatIdEl.value.trim(); if(!chatId) return;
  const fd = new FormData();
  fd.append('ajax','set_bot'); fd.append('chat_id', chatId);
  fd.append('muted', muteEl.checked ? '0' : '1'); // checked = bot ON
  await fetch('', { method:'POST', body: fd });
});

form.addEventListener('submit', async (e)=>{
  e.preventDefault();
  const chatId = chatIdEl.value.trim();
  const route = routeEl.value.trim();
  const text = replyEl.value.trim();
  if(!chatId || !text) return;
  sendBtn.disabled = true;
  tBody.appendChild(bubble('bot', text, new Date().toLocaleString(), null, null, (tDomain.textContent||'')));
  scrollBottom();
  try{
    const fd = new FormData();
    fd.append('ajax','send'); fd.append('chat_id', chatId);
    fd.append('route', route); fd.append('message', text);
    await fetch('', { method:'POST', body: fd });
    replyEl.value='';
  }catch(err){
    alert('Network error'); console.error(err);
  }finally{
    sendBtn.disabled = false;
  }
});

replyEl.addEventListener('keydown', (e)=>{
  if(e.key==='Enter' && !e.shiftKey){ e.preventDefault(); form.dispatchEvent(new Event('submit')); }
});
</script>
</body>
</html>
