<?php
header('Content-Type: text/plain; charset=UTF-8');

// Accept JSON bodies too
$raw = file_get_contents('php://input');
if ($raw && empty($_POST)) {
    $j = json_decode($raw, true);
    if (json_last_error() === JSON_ERROR_NONE && is_array($j)) {
        $_POST = $j + $_POST;
    }
}

$filename = $_POST['filename'] ?? ('blog-'.time().'.html');
$content  = $_POST['content']  ?? '';

// normalize filename (flat, no dirs)
$filename = preg_replace('#[^\w\-.]+#','-', $filename);
$filename = ltrim($filename, '/');

// paths like /Blog/posts/
$folder = __DIR__ . '/posts/';
if (!is_dir($folder)) {
    if (!mkdir($folder, 0755, true)) {
        http_response_code(500);
        exit("❌ Cannot create folder: $folder");
    }
}

// If no content provided, make a small placeholder (or abort)
if ($content === '') {
    // return error if you prefer:
    // http_response_code(400); exit("⚠️ No content received.");
    $published = date('Y-m-d');
    $content = "<!doctype html><html lang=\"de\"><head><meta charset=\"utf-8\"><title>Platzhalter</title></head><body><main><h1>Wird bald gefüllt</h1><p>$published</p></main></body></html>";
}

$full = $folder . $filename;
$bytes = file_put_contents($full, $content);

if ($bytes === false) {
    http_response_code(500);
    exit("❌ Write failed: $full");
}
echo "✅ File created: $full ($bytes bytes)";
